package com.qiho.center.api.enums.strategy;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.strategy.StrategyGroupDto;
import com.qiho.center.api.dto.strategy.StrategyItemDto;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * Created by zhangshun on 2020/3/5.
 */
public enum StrategyGroupEnum {

    MESSAGE("message", "留言", "message", "用户留言"),

    CONSUMER_NAME("name", "姓名", "consumerName", "收件人姓名"),
    CONSUMER_NAME_CUSTOM_API_CONFIG("name", "姓名", "name-custom-config", "自定义规则类型"),


    ADDRESS_INFO("address", "地址", "info-address", "详细地址"),
    ADDRESS_LEN("address", "地址", "address", "详细地址长度"),
    ADDRESS_CUSTOM_API_CONFIG("address", "地址", "address-custom-config", "自定义规则类型"),


    MOBILE("mobile", "手机号", "mobile", "下单手机号状态"),
    MOBILE_COUNT("mobile", "手机号", "count-mobile", "下单量(手机号统计)"),
    mobile_ct_item("mobile", "手机号", "ct-phone-item", "下单量(同一手机号同一商品)"),
    MOBILE_CT_MERCHANT("mobile", "手机号", "ct-phone-merchant", "下单量(同一手机号同一商家)"),
    MOBILE_QUALIFICATION("mobile","手机号", "mobile-order-qualification", "六律-手机号下单资格"),
    MOBILE_DUPLICATE_HIT("mobile", "手机号", "mobile-duplicate-hit", "手机号多次命中现有规则"),
    ZUOYEBANG_OVERSOLD("mobile", "手机号", "zuoyebang-oversold", "作业帮-商品超卖"),
    MOBILE_FLOW_PACKET_CALIBRATION("mobile", "手机号", "ll-flow-packet-calibration", "六律流量包办理校验"),
    MOBILE_CUSTOM_API_CONFIG("mobile", "手机号", "mobile-custom-config", "自定义规则类型"),
    SSD_ORDER_TOP_UP("mobile", "手机号", "ssd-order-top-up", "三思德-下单充值"),

    ADDRESS_INVALID("address_invalid", "地址&地区", "invalid-address", "地址有效性"),

    ADDRESS_MOBILE("address_mobile", "地址&手机号", "ip-mobile-address-check", "IP归属地手机号归属地收货地址校验"),

    OTHER_tuiaId("other", "其他", "tuiaId", "推啊id"),
    OTHER_remainTime("other", "其他", "remainTime", "页面停留时长(秒)"),
    OTHER_itemNo("other", "其他", "itemNo", "货号"),
    OTHER_itemId("other", "其他", "itemId", "商品id"),
    OTHER_quantity("other", "其他", "quantity", "订单件数"),
    OTHER_countTuiaId("other", "其他", "count-tuiaId", "下单量(推啊id统计)"),
    OTHER_countIp("other", "其他", "count-ip", "下单量（ip统计）"),
    OTHER_countTuiacid("other", "其他", "count-tuiacid", "下单量(推啊用户id统计)"),
    OTHER_UNICOM_CARD_RISK_CONTROL("other", "其他", "unicom-card-risk-control", "联通卡风控"),

    DELIVERY_REGION("region","地区","delivery-region","用户收货地址校验"),
    DELIVERY_REGION_CUSTOM_API_CONFIG("region","地区","delivery-region-custom-config","自定义规则类型"),

    ID_CARD_AGE("id_card","身份证","age-idCard","身份证年龄"),
    ID_CARD_FORMAT("id_card","身份证","format-idCard","身份证格式"),
    ID_CARD_AREA("id_card","身份证","area-idCard","身份证区号"),
    ID_CARD_COUNT("id_card", "身份证", "count-idCard", "下单量(身份证号统计)"),
    ID_CARD_ITEM("id_card", "身份证", "ct-idCard-item", "下单量(同一身份证，同一商品)"),
    ID_CARD_MERCHANT("id_card", "身份证", "ct-idCard-merchant", "下单量(同一身份证，同一店铺)"),
    ID_CARD_NAME_VALID("id_card", "身份证", "name-idCard", "六律-身份证姓名匹配"),
    ID_CARD_KAISU_NAME_VALID("id_card", "身份证", "kaisu-name-idCard", "开速-身份证姓名匹配"),
    ID_CARD_CUSTOM_API_CONFIG("id_card", "身份证", "idCard-custom-config", "自定义规则类型"),
    ID_CARD_YIZUN_NAME_VALID("id_card", "身份证", "yizun-card-name", "易尊-身份证姓名匹配"),

    ID_CARD_BAIQI_NAME_VALID("id_card", "身份证", "baiqi-name-idCard", "百奇-身份证姓名匹配")

    ;

    private String strategyCode;
    private String strategyType;
    private String itemName;
    private String itemCode;

    StrategyGroupEnum(String strategyCode, String strategyType, String itemCode, String itemName) {
        this.strategyCode = strategyCode;
        this.strategyType = strategyType;
        this.itemName = itemName;
        this.itemCode = itemCode;
    }

    public static List<StrategyGroupDto> getStrategyGroupList(String strategyType) {
        List<StrategyGroupEnum> list = Lists.newArrayList();
        List<StrategyGroupEnum> finalList = list;
        Arrays.stream(StrategyGroupEnum.values())
            .forEach(item -> finalList.add(item));

        // if (StringUtils.isNotBlank(strategyCode)) {
        //     list = list.stream().filter(v -> StringUtils.equals(v.getStrategyCode(), strategyCode)).collect(Collectors.toList());
        // }

        Map<String, List<StrategyGroupEnum>> map = list.stream()
            .collect(Collectors.groupingBy(StrategyGroupEnum::getStrategyCode));

        Map<String, String> codeNameMap = list.stream()
            .collect(Collectors.toMap(StrategyGroupEnum::getStrategyCode, StrategyGroupEnum::getStrategyType, (l, r) -> r));

        List<StrategyGroupDto> dtoList = new ArrayList<>();
        map.forEach((k, v) -> {
            List<StrategyItemDto> itemList = new ArrayList<>();
            v.forEach(item -> {
                // 下单策略
                if (StringUtils.equalsIgnoreCase(StrategyType.AHEAD_PREVENT_ORDER.getValue(), strategyType)) {// NOSONAR
                    if (StringUtils.equals(item.getItemCode(), ADDRESS_MOBILE.getItemCode())
                        || StringUtils.equals(item.getItemCode(), OTHER_countTuiacid.getItemCode())
                    //    || StringUtils.equals(item.getItemCode(), ADDRESS_INVALID.getItemCode())
                        || StringUtils.equals(item.getItemCode(), MOBILE.getItemCode())
                        || StringUtils.equals(item.getItemCode(), MOBILE_DUPLICATE_HIT.getItemCode())) {
                        return ;
                    }
                } else if (StringUtils.equalsIgnoreCase(StrategyType.SHOT_ORDER.getValue(), strategyType)) {
                    if (StringUtils.equals(item.getItemCode(), MOBILE_DUPLICATE_HIT.getItemCode())
                        || StringUtils.equals(item.getItemCode(), ID_CARD_AGE.getItemCode())
                        || StringUtils.equals(item.getItemCode(), ID_CARD_AREA.getItemCode())
                        || StringUtils.equals(item.getItemCode(), ID_CARD_FORMAT.getItemCode())
                        || StringUtils.equals(item.getItemCode(), MOBILE_FLOW_PACKET_CALIBRATION.getItemCode())
                        || StringUtils.equals(item.getItemCode(), ZUOYEBANG_OVERSOLD.getItemCode())) {
                        return;
                    }
                } else if (Strings.isNullOrEmpty(strategyType)) {
                    if (StringUtils.equals(item.getItemCode(), ID_CARD_AGE.getItemCode())
                        || StringUtils.equals(item.getItemCode(), ID_CARD_AREA.getItemCode())
                        || StringUtils.equals(item.getItemCode(), ID_CARD_FORMAT.getItemCode())
                        || StringUtils.equals(item.getItemCode(), MOBILE_FLOW_PACKET_CALIBRATION.getItemCode())
                        || StringUtils.equals(item.getItemCode(), ZUOYEBANG_OVERSOLD.getItemCode())) {
                        return;
                    }
                }
                StrategyItemDto dto = new StrategyItemDto();
                dto.setItemCode(item.getItemCode());
                dto.setItemName(item.getItemName());
                itemList.add(dto);
            });
            if (CollectionUtils.isNotEmpty(itemList)) {
                StrategyGroupDto groupDto = new StrategyGroupDto();
                groupDto.setStrategyCode(k);
                groupDto.setStrategyType(codeNameMap.get(k));
                groupDto.setItemList(itemList);
                dtoList.add(groupDto);
            }

        });
        return dtoList;
    }

    public static Map<String, String> getCodeMap() {
        Map<String, String> map = new HashMap<>();
        for (StrategyGroupEnum sge : StrategyGroupEnum.values()) {
            map.put(sge.getItemCode(), sge.getStrategyCode());
        }
        return map;
    }

    public String getStrategyCode() {
        return strategyCode;
    }

    public void setStrategyCode(String strategyCode) {
        this.strategyCode = strategyCode;
    }

    public String getStrategyType() {
        return strategyType;
    }

    public void setStrategyType(String strategyType) {
        this.strategyType = strategyType;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

}
