package com.qiho.center.api.params;

import java.io.Serializable;

/**
 * Created by liuyao on 2017/5/22.
 * 分页参数封装类
 */
public class PageQueryParams implements Serializable {

    private Integer offset;
    private Integer max;
    /**
     * 当前页最大或最小Id,
     */
    private Long offsetId;
    private boolean needCount = true;

    /**
     * 无参构造函数
     */
    public PageQueryParams(){
        this.max = 20;
        this.offset = 0;
    }

    /**
     * 指定位移和加载个数
     * @param offset
     * @param max
     */
    public PageQueryParams(int offset, int max){
        this.offset = offset;
        this.max = max;
    }

    public Integer getOffset() {
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getMax() {
        return max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public Long getOffsetId() {
        return offsetId;
    }

    public void setOffsetId(Long offsetId) {
        this.offsetId = offsetId;
    }

    public boolean isNeedCount() {
        return needCount;
    }

    public void setNeedCount(boolean needCount) {
        this.needCount = needCount;
    }
}
