/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.uid.mq.product;

import com.alibaba.fastjson.JSON;
import com.youqian.uid.utils.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MqProductComponent {
    private static final Logger log = LoggerFactory.getLogger(MqProductComponent.class);
    @Autowired
    private DefaultMQProducer defaultMQProducer;

    public Boolean send(Object dto, String topic, String tag) {
        boolean result = false;
        if (Objects.isNull(dto)) {
            return Boolean.FALSE;
        }
        String body = dto instanceof String ? (String)dto : JsonUtils.toJsonString(dto);
        try {
            Message message = new Message(topic, tag, body.getBytes("UTF-8"));
            SendResult send = this.defaultMQProducer.send(message);
            if (Objects.nonNull(send) && SendStatus.SEND_OK.equals((Object)send.getSendStatus())) {
                result = true;
            } else {
                log.error("send mq error, send={}, body={}", (Object)JSON.toJSONString((Object)send), (Object)body);
            }
        }
        catch (MQBrokerException | MQClientException | RemotingException e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a{}", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u7cfb\u7edf\u4e0d\u652f\u6301utf-8");
        }
        return result;
    }
}

