/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.uid.plugin;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object entity;
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        if (this.check(mappedStatement, entity = args[1])) {
            Set<Object> entitySet = this.getEntitySet(entity);
            for (Object object : entitySet) {
                this.process(object);
            }
        }
        return invocation.proceed();
    }

    private Set<Object> getEntitySet(Object object) {
        HashSet<Object> set = new HashSet<Object>();
        if (object instanceof Map) {
            Collection values = (Collection)((Map)object).get("list");
            log.info("values = [{}]", (Object)values);
            for (Object value : values) {
                if (value instanceof Collection) {
                    set.addAll((Collection)value);
                    continue;
                }
                set.add(value);
            }
        } else {
            set.add(object);
        }
        return set;
    }

    abstract void process(Object var1) throws Throwable;

    abstract boolean check(MappedStatement var1, Object var2);

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

