/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.uid.plugin;

import com.google.common.base.Predicate;
import com.youqian.uid.UidGenerator;
import com.youqian.uid.annotation.AutoId;
import com.youqian.uid.plugin.AbstractInterceptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Signature;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class AutoIdInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AutoIdInterceptor.class);
    private Map<Class, List<Handler>> handlerMap = new ConcurrentHashMap<Class, List<Handler>>();
    private UidGenerator uidGenerator;

    public AutoIdInterceptor() {
    }

    public AutoIdInterceptor(UidGenerator uidGenerator) {
        this.uidGenerator = uidGenerator;
    }

    @Override
    boolean check(MappedStatement mappedStatement, Object entity) {
        return "INSERT".equalsIgnoreCase(mappedStatement.getSqlCommandType().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Object object) throws Throwable {
        Class<?> handlerKey = object.getClass();
        List<Handler> handlerList = this.handlerMap.get(handlerKey);
        if (handlerList == null) {
            AutoIdInterceptor autoIdInterceptor = this;
            synchronized (autoIdInterceptor) {
                handlerList = this.handlerMap.get(handlerKey);
                if (handlerList != null) {
                } else {
                    handlerList = new ArrayList<Handler>();
                    this.handlerMap.put(handlerKey, handlerList);
                    Set allFields = ReflectionUtils.getAllFields(object.getClass(), (Predicate[])new Predicate[]{input -> input != null && input.getAnnotation(AutoId.class) != null});
                    for (Field field : allFields) {
                        AutoId annotation = field.getAnnotation(AutoId.class);
                        if (field.getType().isAssignableFrom(String.class)) {
                            if (annotation.value().equals((Object)AutoId.IdType.UUID)) {
                                handlerList.add(new UUIDHandler(field));
                                continue;
                            }
                            if (!annotation.value().equals((Object)AutoId.IdType.SNOWFLAKE)) continue;
                            handlerList.add(new UniqueLongHexHandler(field));
                            continue;
                        }
                        if (!field.getType().isAssignableFrom(Long.class) || !annotation.value().equals((Object)AutoId.IdType.SNOWFLAKE)) continue;
                        handlerList.add(new UniqueLongHandler(field));
                    }
                }
            }
        }
        for (Handler handler : handlerList) {
            handler.accept(object);
        }
    }

    private class UniqueLongHexHandler
    extends Handler {
        UniqueLongHexHandler(Field field) {
            super(field);
        }

        @Override
        void handle(Field field, Object object) throws Throwable {
            field.set(object, String.format("%016x", AutoIdInterceptor.this.uidGenerator.getUID()));
        }
    }

    private class UniqueLongHandler
    extends Handler {
        UniqueLongHandler(Field field) {
            super(field);
        }

        @Override
        void handle(Field field, Object object) throws Throwable {
            field.set(object, AutoIdInterceptor.this.uidGenerator.getUID());
        }
    }

    private static class UUIDHandler
    extends Handler {
        UUIDHandler(Field field) {
            super(field);
        }

        @Override
        void handle(Field field, Object object) throws Throwable {
            field.set(object, UUID.randomUUID().toString().replace("-", ""));
        }
    }

    private static abstract class Handler {
        Field field;

        Handler(Field field) {
            this.field = field;
        }

        abstract void handle(Field var1, Object var2) throws Throwable;

        private boolean checkField(Object object, Field field) throws IllegalAccessException {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(object) == null;
        }

        public void accept(Object o) throws Throwable {
            if (this.checkField(o, this.field)) {
                this.handle(this.field, o);
            }
        }
    }
}

