/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.uid.plugin;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import com.youqian.uid.UidGenerator;
import com.youqian.uid.plugin.AutoIdInterceptor;
import com.youqian.uid.plugin.RedundantInterceptor;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

@Configuration
@ConditionalOnClass(value={SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class, UidGenerator.class})
@ImportResource(locations={"classpath:uid/cached-uid-spring.xml"})
public class MybatisPluginConfiguration {
    private static RedundantInterceptor redundantInterceptor;
    private static Object lock;

    @Bean
    public static AutoIdInterceptor autoIdInterceptor(UidGenerator uidGenerator) {
        return new AutoIdInterceptor(uidGenerator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedundantInterceptor initRedundantInterceptor() {
        if (redundantInterceptor == null) {
            Object object = lock;
            synchronized (object) {
                if (redundantInterceptor == null) {
                    redundantInterceptor = new RedundantInterceptor();
                }
            }
        }
        return redundantInterceptor;
    }

    @Bean
    public static SpecifiedBeanPostProcessor<SqlSessionFactoryBean> mybatisAddPluginPostProcessorConfigurer(final UidGenerator uidGenerator) {
        return new SpecifiedBeanPostProcessor<SqlSessionFactoryBean>(){

            public int getOrder() {
                return -1;
            }

            public Class<SqlSessionFactoryBean> getBeanType() {
                return SqlSessionFactoryBean.class;
            }

            public Object postProcessBeforeInitialization(SqlSessionFactoryBean bean, String beanName) throws BeansException {
                Interceptor[] interceptors = new Interceptor[]{MybatisPluginConfiguration.autoIdInterceptor(uidGenerator), MybatisPluginConfiguration.initRedundantInterceptor()};
                bean.setPlugins(interceptors);
                return bean;
            }

            public Object postProcessAfterInitialization(SqlSessionFactoryBean bean, String beanName) throws BeansException {
                return bean;
            }
        };
    }

    static {
        lock = new Object();
    }
}

