/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.uid.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Predicate;
import com.youqian.uid.annotation.Redundant;
import com.youqian.uid.annotation.RedundantId;
import com.youqian.uid.config.MqConfig;
import com.youqian.uid.event.RedundantEvent;
import com.youqian.uid.mq.product.MqProductComponent;
import com.youqian.uid.plugin.AbstractInterceptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Signature;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
@Component
public class RedundantInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RedundantInterceptor.class);
    @Autowired
    private MqProductComponent mqProductComponent;
    @Autowired
    private MqConfig mqConfig;
    private Map<Class, List<RedundantEvent>> handlerMap = new ConcurrentHashMap<Class, List<RedundantEvent>>();
    private String suffix = "_entity";
    private String filter_suffix = "redundant";

    @Override
    boolean check(MappedStatement mappedStatement, Object entity) {
        if (mappedStatement.getId().endsWith(this.filter_suffix)) {
            return false;
        }
        if ("UPDATE".equals(mappedStatement.getSqlCommandType().name())) {
            Redundant redundantClass = entity.getClass().getAnnotation(Redundant.class);
            return redundantClass != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Object object) throws Throwable {
        Boolean send;
        Class<?> handlerKey = object.getClass();
        ArrayList<RedundantEvent> handlerList = new ArrayList<RedundantEvent>();
        RedundantInterceptor redundantInterceptor = this;
        synchronized (redundantInterceptor) {
            Class[] targetClasses;
            Set allFields = ReflectionUtils.getAllFields(object.getClass(), (Predicate[])new Predicate[0]);
            HashMap<String, Object> resource = new HashMap<String, Object>(20);
            for (Field field : allFields) {
                field.setAccessible(true);
                Object value = field.get(object);
                resource.put(field.getName(), value);
            }
            Redundant redundantClass = handlerKey.getAnnotation(Redundant.class);
            for (Class targetClass : targetClasses = redundantClass.name()) {
                Set targetFields = ReflectionUtils.getAllFields((Class)targetClass, (Predicate[])new Predicate[]{input -> input != null && input.getAnnotation(RedundantId.class) != null && input.getAnnotation(RedundantId.class).resource().getSimpleName().equals(handlerKey.getSimpleName())});
                if (targetFields.size() == 0) continue;
                String tableName = RedundantInterceptor.getTransformFieldName(targetClass.getSimpleName());
                if (tableName.endsWith(this.suffix)) {
                    tableName = tableName.substring(1, tableName.length() - this.suffix.length());
                }
                RedundantEvent.KeyValue primaryField = null;
                RedundantEvent.KeyValue redundantField = null;
                for (Field targetField : targetFields) {
                    RedundantId redundantId = targetField.getAnnotation(RedundantId.class);
                    Object value = resource.get(redundantId.name());
                    if (value != null) {
                        redundantField = new RedundantEvent.KeyValue();
                        redundantField.setKey(targetField.getName());
                        redundantField.setValue(value);
                        Object rely = resource.get(redundantId.rely());
                        if (rely != null) {
                            primaryField = new RedundantEvent.KeyValue();
                            primaryField.setKey(redundantId.rely());
                            primaryField.setValue(rely);
                        }
                    }
                    if (primaryField == null || redundantField == null) continue;
                    handlerList.add(new RedundantEvent(tableName, primaryField, redundantField));
                }
            }
        }
        if (handlerList.size() > 0 && !(send = this.mqProductComponent.send(RedundantInterceptor.getSmsHandle(handlerList), this.mqConfig.getYouqianRedundantTopic(), this.mqConfig.getYouqianRedundantTag())).booleanValue()) {
            log.warn("\u5197\u4f59\u66f4\u65b0\u6d88\u606f\u53d1\u9001\u5931\u8d25:[{}]", object);
        }
    }

    private static String getSmsHandle(List<RedundantEvent> events) {
        JSONObject request = new JSONObject();
        request.put("request_id", (Object)System.currentTimeMillis());
        JSONArray d = new JSONArray();
        for (RedundantEvent event : events) {
            d.add((Object)event);
        }
        request.put("data", (Object)d);
        return request.toJSONString();
    }

    private static String getTransformFieldName(String fieldName) {
        String compile = "[A-Z]";
        Pattern humpPattern = Pattern.compile(compile);
        Matcher matcher = humpPattern.matcher(fieldName);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

