/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.uid.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.youqian.uid.utils.BigDecimalDeserializer;
import com.youqian.uid.utils.StringSerializer;
import java.io.IOException;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    public static ObjectMapper objectMapper = new ObjectMapper();

    public static String toJsonString(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("JSON\u5e8f\u5217\u5316\u5931\u8d25, objectClass:{}", (Object)object.getClass().getName(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(String string, Class<T> tClass) {
        if (string == null || tClass == null) {
            log.warn("JSON\u53cd\u5e8f\u5217\u5316\u53c2\u6570\u4e3a\u7a7a, string:{}, tClass:{}", (Object)string, tClass);
            throw new RuntimeException("JSON\u53cd\u5e8f\u5217\u5316\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            return (T)objectMapper.readValue(string, tClass);
        }
        catch (IOException e) {
            log.error("JSON\u53cd\u5e8f\u5217\u5316\u5931\u8d25, string:{}, tClass:{}", new Object[]{string, tClass.getName(), e});
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(String string, TypeReference<T> valueTypeRef) {
        if (string == null || valueTypeRef == null) {
            log.warn("JSON\u53cd\u5e8f\u5217\u5316\u53c2\u6570\u4e3a\u7a7a, string:{}, valueTypeRef:{}", (Object)string, valueTypeRef);
            throw new RuntimeException("JSON\u53cd\u5e8f\u5217\u5316\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            return (T)objectMapper.readValue(string, valueTypeRef);
        }
        catch (IOException e) {
            log.error("JSON\u53cd\u5e8f\u5217\u5316\u5931\u8d25, string:{}, valueTypeRef:{}", new Object[]{string, valueTypeRef, e});
            throw new RuntimeException(e);
        }
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(new StringSerializer<Long>(Long.TYPE));
        simpleModule.addSerializer(new StringSerializer<Long>(Long.class));
        simpleModule.addDeserializer(BigDecimal.class, (JsonDeserializer)new BigDecimalDeserializer());
        objectMapper.registerModule((Module)simpleModule);
    }
}

