package com.youqian.api.dto.wallet;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 商户钱包表
 * @author youqian mybatis generator 
 * 2020-07-15
 */
@Data
public class MerchantWalletDto implements Serializable {
    private static final long serialVersionUID = 1594806753771491L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long walletId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Boolean deleted;

    /**
     * 余额
     * not null default = 0.0000
     */
    private BigDecimal amount;

    /**
     * 冻结金额
     * not null default = 0.0000
     */
    private BigDecimal freezeAmount;
}