package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * @author xiachenhang
 */
@Getter
public enum BaiDuErrorEnum {
    UN_ERROR(399,"百度云未录入异常"),
    UNKNOWN_ERROR(1,"服务器内部错误，请再次请求， 如果持续出现此类错误，请在控制台提交工单联系技术支持团队"),
    SERVICE_TEMPORARILY_UNAVAILABLE(2,"服务暂不可用，请再次请求， 如果持续出现此类错误，请在控制台提交工单联系技术支持团队"),
    UNSUPPORTED_OPEN_API_METHOD(3,"调用的API不存在，请检查后重新尝试"),
    OPEN_API_REQUEST_LIMIT_REACHED(4,"集群超限额"),
    NO_PERMISSION_TO_ACCESS_DATA(6,"无权限访问该用户数据"),
    IAM_CERTIFICATION_FAILED(14,"IAM鉴权失败，建议用户参照文档自查生成sign的方式是否正确，或换用控制台中ak sk的方式调用"),
    DAILY_REQUEST_LIMIT_REACHED(17,"每天请求量超限额"),
    QPS_REQUEST_LIMIT_REACHED(18,"QPS超限额"),
    TOTAL_REQUEST_LIMIT_REACHED(19,"请求总量超限额"),
    INVALID_PARAMETER(100,"无效的access_token参数，请检查后重新尝试"),
    ACCESS_TOKEN_INVALID_OR_NO_LONGER_VALID(110,"access_token无效"),
    ACCESS_TOKEN_EXPIRED(111,"access token过期"),
    INVALID_PARAM(216100,"请求中包含非法参数，请检查后重新尝试"),
    NOT_ENOUGH_PARAM(216101,"缺少必须的参数，请检查参数是否有遗漏"),
    SERVICE_NOT_SUPPORT(216102,"请求了不支持的服务，请检查调用的url"),
    PARAM_TOO_LONG(216103,"请求中某些参数过长，请检查后重新尝试"),
    APP_ID_NOT_EXIST(216110,"appid不存在，请重新核对信息是否为后台应用列表中的appid"),
    EMPTY_IMAGE(216200,"图片为空，请检查后重新尝试"),
    IMAGE_FORMAT_ERROR(216201,"上传的图片格式错误，现阶段我们支持的图片格式为：PNG、JPG、JPEG、BMP，请进行转码或更换图片"),
    IMAGE_SIZE_ERROR(216202,"上传的图片大小错误，现阶段我们支持的图片大小为：base64编码后小于4M，分辨率不高于4096*4096，请重新上传图片"),
    RECOGNIZE_ERROR(216630,"识别错误，请再次请求，如果持续出现此类错误，请在控制台提交工单联系技术支持团队"),
    RECOGNIZE_BANK_CARD_ERROR(216631,"识别银行卡错误，出现此问题的原因一般为：您上传的图片非银行卡正面，上传了异形卡的图片或上传的银行卡正品图片不完整"),
    RECOGNIZE_ID_CARD_ERROR(216633,"识别身份证错误，出现此问题的原因一般为：您上传了非身份证图片或您上传的身份证图片不完整"),
    DETECT_ERROR(216634,"检测错误，请再次请求，如果持续出现此类错误，请在控制台提交工单联系技术支持团队"),
    INTERNAL_ERROR(282000,"服务器内部错误，如果您使用的是高精度接口，报这个错误码的原因可能是您上传的图片中文字过多，识别超时导致的，建议您对图片进行切割后再识别，其他情况请再次请求， 如果持续出现此类错误，请在控制台提交工单联系技术支持团队"),
    MISSING_PARAMETERS(282003,"请求参数缺失"),
    BATCH_PROCESSING_ERROR(282005,"处理批量任务时发生部分或全部错误，请根据具体错误码排查"),
    BATCH_TASK_LIMIT_REACHED(282006,"批量任务处理数量超出限制，请将任务数量减少到10或10以下"),
    TARGET_DETECT_ERROR(282102,"未检测到图片中识别目标，请确保图片中包含对应卡证票据"),
    TARGET_RECOGNIZE_ERROR(282103,"图片目标识别错误，请确保图片中包含对应卡证票据，如果持续出现此类错误，请在控制台提交工单联系技术支持团队"),
    URLS_NOT_EXIT(282110,"URL参数不存在，请核对URL后再次提交"),
    URL_FORMAT_ILLEGAL(282111,"URL格式非法，请检查url格式是否符合相应接口的入参要求"),
    URL_DOWNLOAD_TIMEOUT(282112,"url下载超时，请检查url对应的图床/图片无法下载或链路状况不好，您可以重新尝试一下，如果多次尝试后仍不行，建议更换图片地址"),
    URL_RESPONSE_INVALID(282113,"URL返回无效参数"),
    URL_SIZ_ERROR(282114,"URL长度超过1024字节或为0"),
    REQUEST_ID_NOT_EXIST(282808,"request id xxxxx 不存在"),
    RESULT_TYPE_ERROR(282809,"返回结果请求错误（不属于excel或json）"),
    IMAGE_RECOGNIZE_ERROR(282810,"图像识别错误");

    private Integer code;
    private String type;

    BaiDuErrorEnum(Integer code,String type){
        this.code = code;
        this.type  = type;
    }


    public static BaiDuErrorEnum getByType(Integer code){
        return Stream.of(BaiDuErrorEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(UN_ERROR);
    }
}
