package com.youqian.api.params.customer;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * Created by hong
 * time 2020/4/17.
 */
@Data
public class CustomerUpdateParam {

    /**
     * 客户id
     */
    @NotNull(message = "id不能为空")
    private Long id;

    /**
     * 客户名称
     */
    @NotBlank(message = "姓名不能为空")
    @Pattern(regexp = "^(?:[\\u4e00-\\u9fa5·]{2,10})$",message = "姓名应为2-10位汉字")
    private String userName;

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    @Pattern(regexp = "^(?:(?:\\+|00)86)?1\\d{10}$",message = "请输入正确的手机号")
    private String mobile;

    /**
     * 企业名称
     */
    private String enterpriseName;
}
