package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.jetbrains.annotations.NotNull;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/14
 * @description
 */
@Data
@NoArgsConstructor
public class GoodsRequestV2 implements Serializable {

    @NotNull("商品ID不能为空")
    @Min(value = 1, message = "商品ID必须大于0")
    @ApiModelProperty(value = "商品ID", required = true)
    private Long goodsId;

    @NotBlank(message = "商品名称不能为空")
    @ApiModelProperty(value = "商品名称", required = true)
    private String goodsName;

    @NotBlank(message = "商品款号不能为空")
    @ApiModelProperty(value = "商品款号", required = true)
    private String shortName;

    @NotNull("商品单价不能为空")
    @ApiModelProperty(value = "商品单价", required = true)
    private BigDecimal price;

    @Valid
    @NotNull
    @Size(min = 1)
    @ApiModelProperty(value = "规格详情", required = true)
    private List<OrderItemRequestV2> skuList;

}
