package com.youqian.api.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/7
 * @description
 */
@Data
public class OrderItemDetail implements Serializable {

    @Deprecated
    @ApiModelProperty("商品小计（废弃），使用totalPrice代替")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal price;

    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("商品款号")
    private String shortName;

    @ApiModelProperty("商品图片")
    private String goodsImage;

    @ApiModelProperty("商品单价")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal unitPrice;

    @ApiModelProperty("商品小计")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal totalPrice;

    @ApiModelProperty("商品总数量")
    private Integer totalCount = 0;

    @ApiModelProperty("商品详情")
    private List<OrderItemResult> skuList;

    /**
     * 兼容老版本
     *
     * @return totalPrice
     */
    public BigDecimal getPrice() {
        return totalPrice;
    }
}
