package com.youqian.api.dto.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 客户标签表
 * @author youqian mybatis generator 
 * 2020-08-11
 */
@Data
public class CustomerLabelDto implements Serializable {
    private static final long serialVersionUID = 15971160673266770L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long customerLabelId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 标签名称
     * max length = 50
     * not null default = null
     */
    private String name;

    /**
     * 标签类型 1固定标签  2商户添加的标签
     * not null default = null
     */
    private Byte type;

    /**
     * 商户id
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 0访客 1一般客户 2重要客户 3核心客户
     * not null default = -1
     */
    private Integer level;
}