package com.youqian.api.dto.raffle.custom;

import com.youqian.api.dto.raffle.RaffleDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 卖家发起的抽奖详情
 * Created by hong
 * time 2020/7/7.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantRaffleInfoDto extends RaffleDto {

    private static final long serialVersionUID = 3157176691051192700L;

    /**
     * 中奖名单
     * not null default = 0
     */
    private List<DrawDto> DrawList;


    /**
     * 参与人数
     * not null default = 0
     */
    private Integer participateCount=0;

    /**
     * 倒计时
     * not null default = 0
     */
    private Integer countdown;

    /**
     * 直播间名称
     * max length = 20
     * not null default =
     */
    private String roomName;

    /**
     * 商户名称
     * max length = 20
     * not null default =
     */
    private String merchantName;
}
