package com.youqian.api.params;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户列表请求参数(新)
 * Created by hong
 * time 2020/8/15.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerListParamV1 extends PageParam {

    private static final long serialVersionUID = -945789531329411393L;

    /**
     * 排序方式,0-新访客优先  1-最近互动优先   2互动次数优先 默认0
     * @see com.youqian.api.enums.customer.SortPropertyEnumV1
     */
    private Integer sortBy = 0;

    /**
     * 0访客 1一般客户 2重要客户 3核心客户     不传参数（null）全部
     */
    private Integer level;

    /**
     * 模糊搜索 客户名称
     */
    private String  userName;

    /**
     * 商户id
     */
    private Long    merchantId;

    /**
     * 是否加载黑名单
     */
    private Byte  blacklist;
}
