package com.youqian.api.request;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class AddMerchantEmployeeRequest {

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空")
    private String name;

    /**
     * 商户ID
     */
    @NotNull(message = "商户ID不能为空")
    @Min(1)
    private Long merchantId;

    /**
     * 短码
     */
    @NotNull(message = "短码不能为空")
    private Long shortParam;

    /**
     * 用户ID(前端忽略)
     */
    private Long userId;
}
