package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.jetbrains.annotations.NotNull;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/2
 * @description
 */
@Data
@NoArgsConstructor
public class OrderItemRequestV2 implements Serializable {

    @NotNull("规格ID不能为空")
    @Min(value = 1, message = "规格ID必须大于0")
    @ApiModelProperty(value = "规格ID", required = true)
    private Long skuId;

    @ApiModelProperty(value = "数量", required = true)
    private Integer num;

    @NotBlank(message = "商品颜色不能为空")
    @ApiModelProperty(value = "颜色", required = true)
    private String color;

    @NotBlank(message = "商品大小不能为空")
    @ApiModelProperty(value = "大小", required = true)
    private String size;
}
