package com.youqian.api.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class LiveRoomResult implements Serializable {
    /**
     * 创建用户ID
     */
    private Long createUserId;
    /**
     * 直播封面
     */
    private String cover;
    /**
     * 商户ID
     */
    private Long merchantId;
    /**
     * 直播状态
     */
    private Byte roomStatus;
    /**
     * 直播状态名
     */
    private String roomStatusName;
    /**
     * 预计开播时间
     * not null default = null
     */
    private Date expectOpenTime;
    /**
     * 开播时间 时间格式
     */
    private String expectOpenTimeStr;
    /**
     * 直播间名称
     */
    private String roomName;
    /**
     * 直播间间主播头像
     */
    private String avatarUrl;
    /**
     * 直播间Id
     */
    private Long liveRoomId;
    /**
     * 是否观看者
     */
    private Byte visitor;
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 是否即将开播0-否/1-是
     */
    private Integer openSoon = 0;

    /**
     * 直播时长（文本）
     */
    private String liveDuration = "00:00:00";

    /**
     * 直播时长(秒)
     */
    private Long liveDurationSeconds = 0L;

    /**
     * 实际开播时间
     */
    private Date realOpenTime;

    /**
     * 实际关播时间
     */
    private Date realCloseTime;
}
