package com.youqian.api.dto.customer.custom;

import com.youqian.api.dto.PageDto;
import com.youqian.api.dto.customer.CustomerDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * Created by hong
 * time 2020/8/15.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerPageDtoV1 extends PageDto<CustomerPageListDto> {

    private static final long serialVersionUID = 1893220959068629520L;

    /**
     * 今日新增
     */
    private Integer addedToday;

    /**
     * 客户总数
     */
    private Integer customerTotal;

    public static CustomerPageDtoV1 createDto(List<CustomerPageListDto> list, int pageNo, int pageSize, int totalSize) {
        CustomerPageDtoV1 pageDto = new CustomerPageDtoV1();
        pageDto.setList(list);
        pageDto.setPageNo(pageNo);
        pageDto.setPageSize(pageSize);
        pageDto.setTotalSize(totalSize);
        pageDto.setHasNext(list.size() == pageSize&&pageNo*pageSize!=totalSize);
        int totalPage = (totalSize % pageSize == 0) ? totalSize / pageSize : (totalSize / pageSize + 1);
        pageDto.setTotalPages(totalPage);
        return pageDto;
    }
}