package com.youqian.api.dto.customer.custom;

import lombok.Data;

import java.util.Date;

/**
 * 商户所有的客户标签及客户的绑定状态
 * Created by hong
 * time 2020/8/12.
 */
@Data
public class MerchantCustomerLabelDto {
    private static final long serialVersionUID = 15971160673266770L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long customerLabelId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 标签名称
     * max length = 50
     * not null default = null
     */
    private String name;

    /**
     * 标签类型 1固定标签  2商户添加的标签
     * not null default = null
     */
    private Byte type;

    /**
     * 商户id
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 0访客 1一般客户 2重要客户 3核心客户
     * not null default = -1
     */
    private Integer level;

    /**
     * 是否绑定
     */
    private Boolean selected;
}
