package com.youqian.api.dto.redpack;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 红包流水表
 * @author youqian mybatis generator 
 * 2020-07-17
 */
@Data
public class RedpackBillDto implements Serializable {
    private static final long serialVersionUID = 1594967621305281L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long redpackBillId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Boolean deleted;

    /**
     * 领取时间
     */
    private Date receiveTime;

    /**
     * 订单号
     * max length = 25
     * not null default = null
     */
    private String bizTradeNo;

    /**
     * 申请商户号的appid或商户号绑定的appid
     * max length = 128
     * not null default = null
     */
    private String appId;

    /**
     * 用户的标识，对公众号唯一
     * max length = 128
     * not null default = null
     */
    private String openId;

    /**
     * 用户真实ip
     * max length = 32
     * not null default = null
     */
    private String clientIp;

    /**
     * 错误码信息
     * max length = 64
     * not null default = 
     */
    private String errCode;

    /**
     * 失败码信息
     * not null default = 0
     */
    private Integer failCode;

    /**
     * 收入或支出金额
     * not null default = 0.0000
     */
    private BigDecimal amount;

    /**
     * 收入或支出 1收入 2支出
     * not null default = 1
     */
    private Byte incomeOrExpenses;

    /**
     * 用户id
     * not null default = 0
     */
    private Long userId;

    /**
     * 备注
     * max length = 255
     * not null default = 
     */
    private String remark;

    /**
     * 红包详情
     * max length = 255
     * not null default = 
     */
    private String detail;

    /**
     * 发放后红包余额
     * not null default = 0.0000
     */
    private BigDecimal balance;

    /**
     * 商户id
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 直播id
     * not null default = null
     */
    private Long liveId;

    /**
     * 用户参与红包id
     * not null default = null
     */
    private Long redpackParticipationId;

    /**
     * 红包id
     */
    private Long redpackId;
}