package com.youqian.api.enums.redpack;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/7/20.
 */
@Getter
public enum RedpackGrantStatusEnum {
    NOT_ACTIVE((byte)-1,"take_effect","未生效"),
    ISSUING((byte)0,"issuing","正在发放"),
    TO_BE_RELEASED((byte)1,"to_be_released","待发放"),
    ISSUING_COMPLETED((byte)2,"issuing_completed","发放完成"),
    CANCEL_RELEASE((byte)3,"cancel_release","取消发放");

    private final Byte code;

    private final String type;

    private final String desc;

    RedpackGrantStatusEnum(Byte code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static RedpackGrantStatusEnum getByCode(Byte code) {
        return Stream.of(RedpackGrantStatusEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(TO_BE_RELEASED);
    }

    public static RedpackGrantStatusEnum getByType(String type) {
        return Stream.of(RedpackGrantStatusEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(TO_BE_RELEASED);
    }
}

