package com.youqian.api.params.customer;

import cn.com.duiba.wolf.utils.DateUtils;
import com.youqian.api.params.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.Objects;

/**
 * 客户画像中地区分布的请求参数
 * Created by hong
 * time 2020/8/17.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerAreaParam extends PageParam {

    private static final long serialVersionUID = 915539516240582756L;

    /**
     * 查询时间 0全部 1近7日  2近30日
     */
    private Integer queryTimeType;

    /**
     * 开始时间（自动计算）
     */
    private Date startTime;

    /**
     * 结束时间（自动计算）
     */
    private Date endTime;

    /**
     * 省
     */
    private String province;

    public void setQueryTimeType(Integer queryTimeType) {
        Date date = new Date();
        if(Objects.equals(queryTimeType, 1)){
            endTime= DateUtils.getDayEndTime(date);
            startTime = DateUtils.getDayStartTime(DateUtils.daysAddOrSub(date, -7));
        }else if(Objects.equals(queryTimeType,2)){
            endTime=DateUtils.getDayEndTime(date);
            startTime = DateUtils.getDayStartTime(DateUtils.daysAddOrSub(date, -30));
        }
        this.queryTimeType = queryTimeType;
    }

    /**
     * 商户id
     */
    private Long    merchantId;
}
