package com.youqian.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.dto.raffle.RaffleDto;

import java.util.List;

/**
 * 抽奖rpc
 * Created by hong
 * time 2020/7/7.
 */
@AdvancedFeignClient
public interface RemoteRaffleService {

    /**
     * 用户参与抽奖数据插入
     * @param raffleId 抽奖id
     */
    Boolean userParticipate(Long raffleId,Long userId);

    /**
     * 根据直播id和抽奖状态查询抽奖
     * @param liveId 直播id
     * @param status 抽奖状态
     * @return
     */
    List<RaffleDto> getRaffleByLiveIdAndStatus(Long liveId, Byte status);

    /**
     * 抽奖结果计算
     * @param raffleDto 抽奖dto
     */
    void raffleResult(RaffleDto raffleDto);
}
