package com.youqian.api.dto.accesslog;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播邀约表
 * @author youqian mybatis generator 
 * 2020-09-07
 */
@Data
public class AccessInviteDto implements Serializable {
    private static final long serialVersionUID = 15994462645766965L;

    /**
     * 自增键ID
     * not null default = null
     */
    private Long id;

    /**
     * 访问线索ID
     * not null default = 0
     */
    private Long accessInviteId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 员工ID
     * not null default = 0
     */
    private Long employeeId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 被邀请的用户ID
     * not null default = 0
     */
    private Long customerUserId;

    /**
     * 是否新访客
     * not null default = 0
     */
    private Byte firstVisitor;

    /**
     * 客户ID
     */
    private Long customerId;

    /**
     * 邀请来源
     */
    private Byte inviteSource;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}