package com.youqian.api.dto.page.custom;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2020/9/9.
 */
@Data
public class PageComponentCustomDto implements Serializable {

    private static final long serialVersionUID = 2832292039462883162L;

    /**
     * 唯一id
     * not null default = null
     */
    private Long componentId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 组件名
     * max length = 50
     * not null default = null
     */
    private String componentName;

    /**
     * 所属页面id
     * not null default = 0
     */
    private Long pageId;

    /**
     * 所属类别id
     * not null default = null
     */
    private Long componentCategoryId;

    /**
     * 是否默认
     * not null default = 0
     */
    private Byte whetherDefault;

    /**
     * 纵向显示顺序
     * not null default = 0
     */
    private Integer displayOrderY;

    /**
     * 横向显示顺序
     * not null default = 0
     */
    private Integer displayOrderX;

    /**
     * 颜色
     * max length = 10
     */
    private String color;

    /**
     * 组件样式
     * max length = 255
     */
    private String componentStyle;

    /**
     * 组件等级 1父组件 2子组件
     * not null default = 1
     */
    private Integer componentLevel;

    /**
     * 父组件id
     * not null default = 0
     */
    private Long parentComponentId;

    /**
     * 子组件集合
     */
    private List<PageComponentCustomDto> pageChildComponents;
}
