package com.youqian.api.dto.page.custom;

import com.youqian.api.dto.page.PageComponentDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Created by hong
 * time 2020/9/9.
 */
@Data
public class PageCustomDto implements Serializable {

    private static final long      serialVersionUID = 8745869790250388444L;

    /**
     * 页面组件集合
     */
    private List<PageComponentCustomDto> pageComponents;

    /**
     * 唯一id
     * not null default = null
     */
    private Long pageId;

    /**
     * 对应页面路由
     * max length = 255
     * not null default = null
     */
    private String pageRoute;

    /**
     * 页面名
     * max length = 30
     * not null default = null
     */
    private String pageName;

    /**
     * 颜色
     * max length = 10
     */
    private String color;
}
