package com.youqian.api.enums.page;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/9/9.
 */
@Getter
public enum ComponentLevelEnum {

    PARENT_COMPONENT(1,"parent_component","父组件"),
    CHILD_COMPONENT(2,"child_component","子组件"),;

    private final Integer code;

    private final String type;

    private final String desc;

    ComponentLevelEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static ComponentLevelEnum getByCode(Integer code) {
        return Stream.of(ComponentLevelEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(PARENT_COMPONENT);
    }

    public static ComponentLevelEnum getByType(String type) {
        return Stream.of(ComponentLevelEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(PARENT_COMPONENT);
    }
}

