package com.youqian.api.params.merchant.walle;

import com.youqian.api.params.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2020/9/11.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WalleBillParam extends PageParam {

    private static final long serialVersionUID = -2332820517017941861L;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 商户id
     */
    private Long merchantId;

    /**
     * 姓名
     */
    private String userName;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 单号
     */
    private String bizTradeNo;

    /**
     * 根据userName查询的id集合
     */
    private List<Long> userNameIds;

    /**
     * 根据mobile查询的id集合
     */
    private List<Long> mobileIds;

    /**
     * 交易类型
     */
    private Integer billType;
}
