package com.youqian.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.dto.employee.EmployeeDto;
import com.youqian.auth.api.exception.BizException;

import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/21
 * @description
 */
@AdvancedFeignClient
public interface RemoteEmployeeService {

    /**
     * 根据用户ID查询员工信息
     *
     * @param userId userId
     * @return EmployeeDto
     */
    EmployeeDto selectByUserId(Long userId) throws BizException;

    /**
     * 商户下员工
     */
    List<EmployeeDto> selectByMerchantId(Long merchantId);

}
