package com.youqian.api.remoteservice;

import com.youqian.api.dto.accesslog.AccessInviteDto;
import com.youqian.api.dto.accesslog.AccessLogExtDto;
import com.youqian.api.dto.platformuser.PlatformUserDto;
import com.youqian.api.dto.livestatistical.LiveReportStatisticalDto;
import com.youqian.api.request.LiveInfoDataRequest;
import com.youqian.api.request.UserListRequest;
import com.youqian.auth.api.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.request.TokenVRequest;
import com.youqian.api.response.PlatformUserResponse;

import java.util.List;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description
 */
@AdvancedFeignClient
public interface RemoteUserService {

    /**
     * 根据openId获取用户信息
     *
     * @param tokenRequest openId&type
     * @return PlatformUser
     * @throws BizException 用户不存在
     */
    PlatformUserResponse getUserByOpenId(TokenVRequest tokenRequest) throws BizException;

    /**
     * 定时任务处理accessLog的停留时间
     * @throws BizException
     */
    void accessLogJob() throws BizException;

    /**
     * 根据UserId获取用户信息
     *
     * @param userId userId
     * @return PlatformUserDto
     * @throws BizException 用户不存在
     */
    PlatformUserDto getByUserId(Long userId) throws BizException;
    /**
     * 根据UserId组获取用户信息
     *
     * @param userIds userId组
     * @return PlatformUserDto
     * @throws BizException 用户不存在
     */
    List<PlatformUserDto> getByUserIds(List<Long> userIds) throws BizException;

    /**
     * 根据用户ID 查找列表
     *  @param userListRequest 列表参数
     *  @return
     */
    List<PlatformUserDto> selectByUserList(UserListRequest userListRequest);

    /**
     * 根据用户ID 统计
     *  @param userListRequest 列表参数
     *  @return
     */
    Integer countUserList(UserListRequest userListRequest);

    /**
     * 定时任务:直播前的数据统计
     */
    void LivePreInvite();

    /**
     * 查询直播统计表
     * @return 统计列表
     */
    List<LiveReportStatisticalDto> selectByLiveReport();

    /**
     * 更新直播中及直播时的数据
     * @param  liveInfoDataRequests
     * @return
     */
    void updateLiveReportStatistics(List<LiveInfoDataRequest> liveInfoDataRequests);

    /**
     * 初始化直播数据统计表
     * @param liveRoomId 直播间ID
     */
    void initLiveStatistical(Long liveRoomId);

    /**
     * 查询用户进入直播间的线索
     * @param userId 用户ID
     * @param merchantId 商户ID
     * @param liveRoomId 直播间ID
     * @return list
     */
    List<AccessLogExtDto> selectByAccessLogExt(Long userId,Long liveRoomId,Long merchantId);

    /**
     * 查询客户的信息
     * @param liveRoomId 直播间ID
     * @param userIds 用户ID
     * @return 线索
     */
    List<AccessInviteDto> selectByAccessClue(Long liveRoomId, List<Long> userIds);

}
