package com.youqian.api.enums;

import lombok.Getter;

/**
 * 数据库订单状态
 */
@Getter
public enum EnumOrderStatus {
    UNKNOWN((byte) -1, "未知"),
    DRAFT((byte) 0, "草稿"),
    WAIT_CONFIRM((byte) 1, "待确认"),
    WAIT_SEND_GOODS((byte) 2, "已确认"),
    FINISH((byte) 3, "已完成"),
    CANCEL((byte) 4, "已取消"),
    ;

    EnumOrderStatus(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private byte code;
    private String msg;

    public static EnumOrderStatus get(Byte code){
        for(EnumOrderStatus orderStatus:values()){
            if(orderStatus.getCode() == code){
                return orderStatus;
            }
        }
        return UNKNOWN;
    }

}
