package com.youqian.api.params.goods;

import com.youqian.api.params.shoptag.GoodsTagRelationParam;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * 商品操作所需参数
 * Created by hong
 * time 2020/4/8.
 */
@Data
public class    OperateGoodsParam {

    /**
     * 商品id
     */
    private Long                         shopGoodsId;

    /**
     * 商品名
     */
    @NotBlank(message = "商品名不能为空")
    @Size( max= 20,min = 1,message = "商品名应为1-20位")
    private String                       goodsName;

    /**
     * 单位
     */
    @NotBlank(message = "单位不能为空")
    @Pattern(regexp = "^(?:[\\u4e00-\\u9fa5·]{1,5})$",message = "单位应为1-5位汉字")
    private String                       unit;

    /**
     * 是否推荐  1是
     * @see com.youqian.api.enums.TrueOrFalseEnum
     */
    private Integer                      recommend;

    /**
     * 是否上新 1是
     */
    private Byte newPublish;

    /**
     * 是否热卖  1是
     */
    private Byte hot;

    /**
     * 是否促销   1是
     */
    private Byte discount;

    /**
     * 标签数组
     */
    private List<GoodsTagRelationParam>  tags;

    /**
     * 商品图片oss数组
     */
    private List<InsertPicBatchParam>    goodsPics;

    /**
     * 规格操作参数数组
     */
    private List<SkuOperateParam>        skuParams;

    /**
     * 商品id集合(商品删除用)
     */
    private List<Long>                   goodsIds;

    /**
     * 商户ID
     */
    private Long merchantId;
}
