package com.youqian.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.dto.shopgoods.ShopGoodsDto;
import com.youqian.api.dto.shopgoods.custom.tag.GoodsTagAndGoodsCountDto;
import com.youqian.api.params.goods.GoodsListParam;
import com.youqian.api.params.goods.OperateGoodsParam;
import com.youqian.api.response.GoodsListResult;
import com.youqian.auth.api.exception.BizException;

import java.util.Collection;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/21
 * @description
 */
@AdvancedFeignClient
public interface RemoteGoodsService {

    /**
     * 批量查询商品
     *
     * @param goodsIds goodsIds
     * @return List<ShopGoodsDto>
     */
    List<ShopGoodsDto> batchGet(Collection<Long> goodsIds) throws BizException;

    /**
     * 根据商品ID查商品
     *
     * @param goodsId goodsId
     * @return ShopGoodsDto
     */
    ShopGoodsDto selectByGoodsId(Long goodsId) throws BizException;

    /**
     * 添加商品-后台管理
     * @param operateGoodsParam 商品列表请求参数
     */
    void addGoods(OperateGoodsParam operateGoodsParam) throws BizException;

    /**
     * 更新商品-后台管理
     * @param operateGoodsParam 商品列表请求参数
     */
    void updateGoods(OperateGoodsParam operateGoodsParam) throws BizException;

    /**
     * 商品列表-后台管理
     */
    List<GoodsListResult> goodsList(GoodsListParam goodsListParam) throws BizException;

    /**
     * 商品列表-后台管理
     */
    Integer countGoodsList(GoodsListParam goodsListParam) throws BizException;

    /**
     * 标签列表
     */
    List<GoodsTagAndGoodsCountDto> selectByTagList(Long merchantId);
}
