package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.jetbrains.annotations.NotNull;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/14
 * @description
 */
@Data
@NoArgsConstructor
public class GoodsRequest implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "商品ID", required = true)
    private Long goodsId;

    @NotBlank
    @ApiModelProperty(value = "商品名称", required = true)
    private String goodsName;

    @NotBlank
    @ApiModelProperty(value = "单位", required = true)
    private String unit;

    @Valid
    @NotNull
    @Size(min = 1)
    @ApiModelProperty(value = "规格详情", required = true)
    private List<OrderItemRequest> skuList;

}
