package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.jetbrains.annotations.NotNull;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author tengtuox
 * @date 2020/4/2
 * @description
 */
@Data
@NoArgsConstructor
public class OrderItemRequest implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "规格ID", required = true)
    private Long skuId;

    @ApiModelProperty(value = "数量", required = true)
    private Integer num;

    @NotBlank
    @ApiModelProperty(value = "sku名称", required = true)
    private String skuName;

    @ApiModelProperty(value = "单价")
    private BigDecimal price;

    @NotBlank
    @ApiModelProperty(value = "货号", required = true)
    private String sn;

}
