/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.api.enums;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public enum BackLogEnum {
    UN_KNOW("\u672a\u77e5", "unKnow", 0, 0, 0, 0),
    STORE_INFO("\u5b8c\u5584\u5e97\u94fa\u4fe1\u606f", "storeInfo", 1, 0, 0, 0),
    EMPLOYEE_INVITE("\u9080\u8bf7\u65b0\u5458\u5de5", "employeeInvite", 1, 0, 0, 0),
    UPLOAD_GOODS("\u4e0a\u4f201\u6b3e\u5546\u54c1", "uploadGoods", 1, 0, 0, 0),
    FINISH_LIVE("\u5b8c\u62101\u573a\u76f4\u64ad", "finishLive", 1, 0, 0, 0),
    STORE_SHARE("\u5206\u4eab\u76f4\u64ad", "storeShare", 1, 0, 0, 0),
    LIVE_INVITE("\u76f4\u64ad\u9080\u7ea6", "liveInvite", 2, 0, 0, 0),
    LIVE_APPLY("%s\u4e2a\u76f4\u64ad\u7533\u8bf7\u5f85\u5904\u7406", "liveApply", 2, 0, 1, 1),
    FINISH_MONTH_LIVE("\u5b8c\u6210\u672c\u6708%s\u573a\u76f4\u64ad", "finishMonthLive", 2, 0, 0, 1),
    CONFIRM_ORDER_BILL("%s\u6761\u8be2\u4ef7\u5f85\u5904\u7406", "confirmOrderBill", 3, 1, 0, 1),
    CONFIRM_ORDER("%s\u6761\u8ba2\u5355\u5f85\u786e\u8ba4", "confirmOrder", 3, 1, 0, 1),
    DELIVER_ORDER("%s\u6761\u8ba2\u5355\u5f85\u53d1\u8d27", "deliverOrder", 3, 1, 0, 1);

    private final String msg;
    private final String code;
    private final int logType;
    private final int roleType;
    private final int statusType;
    private final int formatType;

    private BackLogEnum(String msg, String code, int logType, int roleType, int statusType, int formatType) {
        this.msg = msg;
        this.code = code;
        this.logType = logType;
        this.roleType = roleType;
        this.statusType = statusType;
        this.formatType = formatType;
    }

    public static BackLogEnum get(String code) {
        if (StringUtils.isBlank((String)code)) {
            return UN_KNOW;
        }
        for (BackLogEnum backLogEnum : BackLogEnum.values()) {
            if (!Objects.equals(backLogEnum.getCode(), code)) continue;
            return backLogEnum;
        }
        return UN_KNOW;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getCode() {
        return this.code;
    }

    public int getLogType() {
        return this.logType;
    }

    public int getRoleType() {
        return this.roleType;
    }

    public int getStatusType() {
        return this.statusType;
    }

    public int getFormatType() {
        return this.formatType;
    }
}

