package com.youqian.api.enums;

import lombok.Getter;

/**
 * @author xiachenhang
 */
@Getter
public enum ActionEnum {
    UN_KNOW((byte)0,"un_know","",""),
    FOLLOW((byte)1,"follow","关注了","店铺名片"),
    COLLECTION((byte)2,"collection","收藏了","商品"),
    ENQUIRY((byte)3,"enquiry","询价了","商品"),
    COME_IN_STORE((byte)4,"comeIn","查看了","店铺名片"),
    COME_IN_STORE_PHOTO((byte)5,"comeIn","浏览了","商品"),
    COME_IN_LIVE_ROOM((byte)6,"comeLiveRoom","进入了","直播间"),
    RESERVE_LIVE_ROOM((byte)7,"reserveLiveRoom","订阅了","直播间"),
    COME_IN_UN_START_LIVE_ROOM((byte)8,"comeUnStartLiveRoom","进入了","直播预告"),
    SHARE_USER_CHURN((byte)9,"","",""),
    ;

    private byte code;
    private String data;
    private String type;
    private String channel;

    ActionEnum(byte code,String data, String type,String channel){
        this.data = data;
        this.code = code;
        this.type = type;
        this.channel = channel;
    }

    public static ActionEnum get(Byte code){
        if(code == null){
            return UN_KNOW;
        }
        for(ActionEnum action:values()){
            if(action.getCode() == code){
                return action;
            }
        }
        return UN_KNOW;
    }

}
