package com.youqian.api.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/7
 * @description
 */
@Data
public class OrderItemDetail implements Serializable {

    @ApiModelProperty("goodsId")
    private Long goodsId;

    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("商品款号")
    private String shortName;

    @ApiModelProperty("商品图片")
    private String goodsImage;

    @ApiModelProperty("商品单价")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal unitPrice;

    @Deprecated
    @ApiModelProperty("商品小计，同totalPrice")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal price;

    @ApiModelProperty("商品小计")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal totalPrice = BigDecimal.ZERO;

    @ApiModelProperty("商品总数量")
    private Integer totalCount = 0;

    @Deprecated
    @ApiModelProperty("商品总数量，同totalCount")
    private Integer num = 0;

    @ApiModelProperty("商品详情")
    private List<OrderItemResult> skuList = new ArrayList<>();

    /**
     * 兼容老版本
     *
     * @return totalPrice
     */
    @Deprecated
    public BigDecimal getPrice() {
        return totalPrice;
    }

    @Deprecated
    public Integer getNum() {
        return totalCount;
    }
}
