package com.youqian.api.dto.accesslog;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播邀约表
 * @author youqian mybatis generator 
 * 2020-09-17
 */
@Data
public class AccessInviteDto implements Serializable {
    private static final long serialVersionUID = 16003324907216190L;

    /**
     * 自增键ID
     * not null default = null
     */
    private Long id;

    /**
     * 访问线索ID
     * not null default = 0
     */
    private Long accessInviteId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 员工ID
     * not null default = 0
     */
    private Long employeeId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 客户ID
     * not null default = 0
     */
    private Long customerId;

    /**
     * 被邀请的用户ID
     * not null default = 0
     */
    private Long customerUserId;

    /**
     * 是否新访客
     * not null default = 0
     */
    private Byte firstVisitor;

    /**
     * 是否订阅
     * not null default = 0
     */
    private Byte liveSub;

    /**
     * 邀请来源
     * not null default = 0
     */
    private Byte inviteSource;

    /**
     * 邀约时机:0-直播前 1-直播中
     * not null default = 0
     */
    private Byte inviteType;

    /**
     * 直播到场
     * not null default = 0
     */
    private Byte liveCome;

    /**
     * 访问时间
     */
    private Date visitorDate;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}