package com.youqian.api.dto.merchant;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 商户标签
 * @author youqian mybatis generator 
 * 2020-03-31
 */
@Data
public class TagDto implements Serializable {
    private static final long serialVersionUID = 15856574218965057L;

    /**
     * 自增键
     * not null default = null
     */
    private Long id;

    /**
     * 标签ID
     * not null default = 0
     */
    private Long tagId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 标签名
     * max length = 100
     * not null default = 
     */
    private String name;

    /**
     * 标签类型：0-客户 1-店铺 2-商品
     * max length = 20
     * not null default = 
     */
    private String type;

    /**
     * 删除标志
     * not null default = 0
     */
    private Byte deleteFlag;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}