package com.youqian.api.dto.page;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 组件模板关系表
 * @author youqian mybatis generator 
 * 2020-09-27
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PageComponentTemplateRDto implements Serializable {
    private static final long serialVersionUID = 16011959762432943L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long componentTemplateRId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 是否默认
     * not null default = 0
     */
    private Byte whetherDefault;

    /**
     * 纵向显示顺序
     * not null default = 0
     */
    private Integer displayOrderY;

    /**
     * 横向显示顺序
     * not null default = 0
     */
    private Integer displayOrderX;

    /**
     * 颜色
     * max length = 10
     */
    private String color;

    /**
     * 组件样式
     * max length = 255
     */
    private String componentStyle;

    /**
     * 组件id
     * not null default = 0
     */
    private Long componentId;

    /**
     * 模板id
     * not null default = null
     */
    private Long pageTemplateId;

    /**
     * 页面id
     * not null default = null
     */
    private Long pageId;
}