package com.youqian.api.dto.page;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 页面模板表
 * @author youqian mybatis generator 
 * 2020-10-13
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PageTemplateDto implements Serializable {
    private static final long serialVersionUID = 16025717691186964L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long pageTemplateId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 模板名
     * max length = 20
     * not null default = null
     */
    private String templateName;

    /**
     * 主颜色
     * max length = 10
     */
    private String mainColor;

    /**
     * 副颜色
     * max length = 10
     */
    private String subColor;

    /**
     * 页面id
     * not null default = null
     */
    private Long pageId;

    /**
     * 模板版本
     * max length = 10
     * not null default = 
     */
    private String templateVersion;

    /**
     * 类别id
     * not null default = null
     */
    private Long pageCategoryId;

    /**
     * 模板描述
     * max length = 255
     */
    private String templateDesc;
}