package com.youqian.api.dto.page.custom;

import com.youqian.uid.annotation.AutoId;
import lombok.Data;

import java.util.Date;

/**
 * Created by hong
 * time 2020/9/29.
 */
@Data
public class ComponentTemplateDto {
    /**
     * 唯一id
     * not null default = null
     */
    private Long componentTemplateRId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 是否默认
     * not null default = 0
     */
    private Byte whetherDefault;

    /**
     * 纵向显示顺序
     * not null default = 0
     */
    private Integer displayOrderY;

    /**
     * 横向显示顺序
     * not null default = 0
     */
    private Integer displayOrderX;

    /**
     * 颜色
     * max length = 10
     */
    private String color;

    /**
     * 组件样式
     * max length = 255
     */
    private String componentStyle;

    /**
     * 组件id
     * not null default = 0
     */
    private Long componentId;

    /**
     * 模板id
     * not null default = null
     */
    private Long pageTemplateId;

    /**
     * 页面id
     * not null default = null
     */
    private Long pageId;

    /**
     * 组件名
     * max length = 50
     * not null default = null
     */
    private String componentName;

    /**
     * 组件等级 1父组件 2子组件
     * not null default = 1
     */
    private Integer componentLevel;

    /**
     * 父组件id
     * not null default = 0
     */
    private Long parentComponentId;

    /**
     * 模板版本
     * max length = 10
     * not null default =
     */
    private String templateVersion;


}
