package com.youqian.api.dto.reportmain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 报价商品关联表
 * @author youqian mybatis generator 
 * 2020-06-11
 */
@Data
public class OrderReportMainBillDto implements Serializable {
    private static final long serialVersionUID = 15918428791192696L;

    /**
     * 自增键ID
     * not null default = null
     */
    private Long id;

    /**
     * 报价ID
     * not null default = 0
     */
    private Long orderReportMainBillId;

    /**
     * 账单表ID
     * not null default = 0
     */
    private Long orderReportMainId;

    /**
     * 报价商品ID
     * not null default = 0
     */
    private Long orderReportBillId;

    /**
     * 原价
     * not null default = 0.00
     */
    private BigDecimal originPrice;

    /**
     * 优惠价格
     * not null default = 0.00
     */
    private BigDecimal reducePrice;

    /**
     * 总价
     * not null default = 0.00
     */
    private BigDecimal totalPrice;

    /**
     * 优惠总价
     * not null default = 0.00
     */
    private BigDecimal reduceTotalPrice;

    /**
     * 总数量
     * not null default = 0
     */
    private Integer goodsNum;

    /**
     * 删除标识
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}