package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * @author tengtuox
 * @date 2020/9/16
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderSearchRequest extends PageRequest implements Serializable {

    @ApiModelProperty("操作人")
    private Operator operator;

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("订单类型")
    private Byte webOrderStatus;

    @ApiModelProperty("订单编号")
    private String orderNumber;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("客户手机号")
    private String customerMobile;

    @ApiModelProperty("客户手机号后四位")
    private String customerMobileLast;

    @ApiModelProperty("客户企业")
    private String customerEnterpriseName;

    @ApiModelProperty("收货人名称")
    private String receiverName;

    @ApiModelProperty("收货人手机号码")
    private String receiverMobile;

    @ApiModelProperty("收货人手机号码后四位")
    private String receiverMobileLast;

    @ApiModelProperty("收货地址")
    private String receiverAddress;

    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("发货方式")
    private Byte transType;

    @ApiModelProperty("开始时间")
    private Date startTime;

    @ApiModelProperty("结束时间")
    private Date endTime;

}
