package com.youqian.api.enums;

import lombok.Getter;
import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 * 待办
 */
@Getter
public enum BackLogEnum {
    /**
     * list
     */
    UN_KNOW("未知","unKnow",0,0,0,0),
    STORE_INFO("完善店铺信息","storeInfo",1,0,0,0),
    EMPLOYEE_INVITE("邀请新员工","employeeInvite",1,0,0,0),
    UPLOAD_GOODS("上传1款商品","uploadGoods",1,0,0,0),
    FINISH_LIVE("完成1场直播","finishLive",1,0,0,0),
    STORE_SHARE("分享店铺","storeShare",1,0,0,0),
    LIVE_INVITE("直播邀约","liveInvite",2,0,0,0),
    LIVE_APPLY("%s个直播申请待处理","liveApply",2,0,1,1),
    FINISH_MONTH_LIVE("完成本月%s场直播","finishMonthLive",2,0,1,1),
    CONFIRM_ORDER_BILL("%s条询价待处理","confirmOrderBill",3,1,0,1),
    CONFIRM_ORDER("%s条订单待确认","confirmOrder",3,1,0,1),
    DELIVER_ORDER("%s条订单待发货","deliverOrder",3,1,0,1),

    ;

    private final String msg;
    private final String code;
    /**
     * 1-新手任务 2-直播运营 3-订单提醒
     */
    private final int logType;
    /**
     * 0-商户维度 1-个人维度(区分管理员和员工权限)
     */
    private final int roleType;
    /**
     * 0-一次性完成 1- 定时清空
     */
    private final int statusType;
    /**
     * 0-不需要拼接 1-需要(String.format())
     */
    private final int formatType;

    BackLogEnum(String msg,String code,int logType,int roleType,int statusType,int formatType){
        this.msg        = msg;
        this.code       = code;
        this.logType    = logType;
        this.roleType   = roleType;
        this.statusType = statusType;
        this.formatType = formatType;
    }

    public static BackLogEnum get(String code){
        if(StringUtils.isBlank(code)){
            return UN_KNOW;
        }
        for(BackLogEnum backLogEnum : values()){
            if(Objects.equals(backLogEnum.getCode(),code)){
                return backLogEnum;
            }
        }
        return UN_KNOW;
    }

}
