package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author tengtuox
 * @date 2020/9/22
 * @description
 */
@Data
public class OrderEmpStatisticsRequest implements Serializable {

    @Min(value = 1, message = "商户ID必须大于0")
    @NotNull(message = "商户ID不能为空")
    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("员工ID")
    private Long employeeId;

    @ApiModelProperty("开始时间")
    private LocalDate startTime;

    @ApiModelProperty("结束时间")
    private LocalDate endTime;

}
