package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author xiachenhang
 */
@Data
public class UpdateOrderReportRequest {

    @NotNull(message = "订货单ID不能为空")
    @Min(value = 1, message = "订货单ID必须大于0")
    @ApiModelProperty("订货单ID")
    private Long orderReportMainId;

    @ApiModelProperty("商品价格列表")
    private List<GoodsPriceResult> goodsPrice;

}
